'Name:          Linus Walleij
'Email_Address: triad@df.lth.se
'Script_Type:   vbscript
'keywords:      MP3 Filename fixing script

'Comment: 
Recursively renames MP3-files to reasonable unscrambled filenames and find proper layer information. IE filenames that "Look%20like_thiS-EXAMPLE%20sonG%20[tEsT].mP3" will "Look Like This - Example Song [Test].mp3" also the files will be renamed to the appropriate extension (for layer 2 files) so .mp2 files will be .mp2 files.

Script:

'**************************************************************
' Written by Linus Walleij with portions from the following
' scripts:
'
' "BrowseForFolder" by Sen Hennessy
' "Return Proper Case" by Chris Lawson
' "Directory Listing Script" by Richard Harrison
'**************************************************************

Option Explicit

'*************************************************************************
' Browse for a folder to process
'*************************************************************************

Function BrowseForFolder(strPrompt)
	On Error Resume Next
	Dim objShell, objFolder, intColonPos, objWshShell
	Set objShell = WScript.CreateObject("Shell.Application")
	Set objWshShell = CreateObject("WScript.Shell")
	Set objFolder = objShell.BrowseForFolder(&H0&, strPrompt, &h1&)
	BrowseForFolder = objFolder.ParentFolder.ParseName(objFolder.Title).Path
	If Err.Number <> 0 Then
		BrowseForFolder = Null 'will be null of no special case applies
		If objFolder.Title = "Desktop" Then
			BrowseForFolder = objWshShell.SpecialFolders("Desktop")
		End If
		'If selected folder is a drive, it will have a colon e.g. C:\
		intColonPos = InStr(objFolder.Title, ":")
		If intColonPos > 0 Then
			BrowseForFolder = Mid(objFolder.Title, intColonPos - 1, 2) & "\"
		End If
	End If
End Function

'*************************************************************************
' Capitalize it nicely
'*************************************************************************

Function Proper(txtName)
    Dim txtRest, txtTmp, intSpcPos, strChar, strLast

	' Convert string to lowercase
    txtRest = LCase(txtName)

	' All characters following a space should be capitalized
    intSpcPos = InStr(1, txtRest, " ")
    Do While intSpcPos <> 0
        txtTmp = txtTmp & UCase(Left(txtRest, 1)) & Mid(txtRest, 2,(intSpcPos - 1))
        txtRest = Mid(txtRest, intSpcPos + 1, Len(txtRest))
        intSpcPos = InStr(1, txtRest, " ")
    Loop
    txtRest = txtTmp & UCase(Left(txtRest, 1)) & Mid(txtRest, 2,Len(txtRest))

	'Add capitalization after certain letters...
	txtTmp=""
	strLast=" "
	For intSpcPos=1 To Len(txtRest)
		strChar = Mid(txtRest,intSpcPos,1)
		Select Case strLast
		Case "["
			txtTmp = txtTmp & Ucase(strChar)
		Case "("
			txtTmp = txtTmp & Ucase(strChar)
		Case "."
			txtTmp = txtTmp & Ucase(strChar)
		Case Else
			txtTmp = txtTmp & strChar
		End Select
		strLast = strChar
	Next

	Proper = txtTmp

End Function

'*************************************************************************
' Count the number of dashes in a name
'*************************************************************************

Function NoOfDashes(strIn)
	Dim intPos, intNoDash
	
	intNoDash = 0
	For intPos=1 To Len(strIn)
		If Mid(strIn,intPos,1)="-" Then intNoDash = intNoDash+1
	Next
	NoOfDashes = intNoDash
End Function

'*******************************************************
' Function for checking if a file is an MP3 file, this
' incredibly cool function checks the MPEG file header
' to see if it is a layer 2 or layer 3 mpeg file.
' Strings ".mp2" or ".mp3" are returned. This can be
' used to check ANY file but is not 100% failsafe...
'*******************************************************

Function strLayerCheck(strCheckFileName)
	'Default to True
	Dim blnValid, MpFile, intLayer
	Dim strHeader, strHdr, bytHdr1, bytHdr2, bytHdr3, bytHdr4
	Dim strSuffix

	blnValid = True
	On Error Resume Next
	Set MpFile = oFileSys.OpenTextFile(strCheckFileName, 1, False, 0)
	If Err.Number = 0 Then
		On Error Resume Next
		strHdr = MpFile.Read(4)
		If Err.Number = 0 Then
			bytHdr1 = Cbyte(AscB(Mid(strHdr,1,1)))
			bytHdr2 = Cbyte(AscB(Mid(strHdr,2,1)))
			bytHdr3 = Cbyte(AscB(Mid(strHdr,3,1)))
			bytHdr4 = Cbyte(AscB(Mid(strHdr,4,1)))
			MpFile.Close
			Set MpFile = Nothing
			' Check if this is a valid MPEG file at all...
			strHeader = Hex(bytHdr1) & Hex(bytHdr2 And 224)
			If strHeader="FFE0" Then
				blnValid = True
			Else
				' Is it a WAV header? That may also be valid...
				' (Probably d00dz converting to wav-encapsulated MP3)
				strHeader = Hex(bytHdr1) & Hex (bytHdr2) & Hex (bytHdr3) & Hex (bytHdr4)
				If strHeader = "52494646" Then
					blnValid = True
				Else
					blnValid = False
				End If
			End If
			' Then proceed to check what layer the file is encoded with
			If blnValid Then
				intLayer = 4 - ((bytHdr2 And 6) / 2)
			Else
				intLayer = 0
			End If
		Else
			' Default on error reading file
			intLayer = 0
			Err.Clear
		End If
	Else
		' Default on error opening file
		intLayer = 0
		Err.Clear
	End If

	' Correct the suffix if identified incorrect
	If blnValid Then
		If intLayer = 2 Then
			strLayerCheck = ".mp2"
		Else
			strLayerCheck = ".mp3"
		End If
	Else
		strLayerCheck = "unknown"
	End If
End Function

'*************************************************************************
' Kill those stoopid URLencodingz
' OK I could've used the Server object method "URLdecode" but I cannot be
' sure that it is available...
'*************************************************************************
Function strURLDecode(strIn)
	Dim i, bytChar, strTmp
	i=1
	strTmp=""
	While (i <= Len(strIn))
		If Mid(strIn,i,1)="%" Then
			' This actually works! I'm surprised...
			bytChar = CByte("&H" & Mid(strIn,i+1,2))
			strTmp = strTmp & Chr(bytChar)
			i=i+2
		Else
			strTmp = strTmp & Mid(strIn,i,1)
		End If
		i=i+1
	Wend
	strURLDecode = strTmp
End Function

'*************************************************************************
' Convert file name using a set of simple rules. OK this is crude but it
' really works. It's my own little EXPERT SYSTEM!
'*************************************************************************

Function ConvertName(strOldName)
	Dim strTmp

	strTmp = strOldName

	'*************************************************************************
	' Insert a check for filename of type "Abba-WhenIKissedTheTeacher" to be
	' detected and splitted into Abba - When I Kissed The Teacher"
	'*************************************************************************

	'*************************************************************************
	' Obvious misuse of dashes instead of spaces
	' this doesnt work DONT ASK WHY, everything seems to "have"
	' more than 3 dashes...
	'If (NoOfDashes(strTmp) < 3) Then
	'	strTmp = Replace(strTmp,"-"," ")
	'End If
	'*************************************************************************

	' Call the function above to remove %20 and similar crap
	strTmp = strURLDecode(strTmp)

	' Kill that stoopid Unix name formatting
	strTmp = Replace(strTmp,"_"," ")
	' Kill that stoopid paranthesis indenting
	strTmp = Replace(strTmp,"( ","(")
	strTmp = Replace(strTmp," )",")")
	strTmp = Replace(strTmp,"[ ","[")
	strTmp = Replace(strTmp," ]","]")
	' Lighten crunched parantheses
	strTmp = Replace(strTmp,")[",") [")
	strTmp = Replace(strTmp,"](","] (")
	' Fix up spacing (OK this is crude too)
	strTmp = Replace(strTmp,"("," (")
	strTmp = Replace(strTmp,")",") ")
	strTmp = Replace(strTmp,"["," [")
	strTmp = Replace(strTmp,"]","] ")
	strTmp = Replace(strTmp,"-"," - ")
	' So it corrects its own mistakes (even cruder)
	strTmp = Replace(strTmp,"  ("," (")
	strTmp = Replace(strTmp,")  ",") ")
	strTmp = Replace(strTmp,"  ["," [")
	strTmp = Replace(strTmp,"]  ","] ")
	strTmp = Replace(strTmp,"] .","].")
	strTmp = Replace(strTmp,") .",").")
	' Replace all kind of double spaces
	strTmp = Replace(strTmp,"  "," ")
	strTmp = Replace(strTmp,"  "," ")
	strTmp = Replace(strTmp,"  "," ")
	' Properize
	strTmp = Proper(strTmp)
	' Some things get TOO proper (OK this is crude)
	strTmp = Replace(strTmp,".Mp3",".mp3")
	strTmp = Replace(strTmp,".Mp2",".mp2")
	strTmp = Replace(strTmp,".Mpa",".mp3")
	strTmp = Replace(strTmp," A "," a ")
	strTmp = Replace(strTmp," An "," an ")
	strTmp = Replace(strTmp," The "," the ")
	strTmp = Replace(strTmp," To "," to ")
	strTmp = Replace(strTmp," Of "," of ")
	strTmp = Replace(strTmp," On "," on ")
	strTmp = Replace(strTmp," In "," in ")
	strTmp = Replace(strTmp," For "," for ")
	strTmp = Replace(strTmp," - a"," - A")
	strTmp = Replace(strTmp," - an"," - An")
	strTmp = Replace(strTmp," - the"," - The")
	strTmp = Replace(strTmp," - to "," - To ")
	strTmp = Replace(strTmp," - of "," - Of ")
	strTmp = Replace(strTmp," - on "," - On ")
	strTmp = Replace(strTmp," - in "," - In ")
	strTmp = Replace(strTmp," - for "," - For ")
	' Some obvious mistakes I've found...
	' add all things you find erroneously named in here.
	strTmp = Replace(strTmp,"Dj ","DJ ")
	strTmp = Replace(strTmp,"Djs ","DJs ")
	strTmp = Replace(strTmp,"DJ - O","DJ O")
	strTmp = Replace(strTmp,"D - Tune","D-Tune")
	strTmp = Replace(strTmp,"Ac - Dc","AC-DC")
	strTmp = Replace(strTmp,"Ccr ","CCR ")
	strTmp = Replace(strTmp,"Atr ","ATR ")
	strTmp = Replace(strTmp,"Abba","ABBA")
	strTmp = Replace(strTmp," Rmx"," RMX")
	strTmp = Replace(strTmp,"B - Charme","B-Charme")
	strTmp = Replace(strTmp," Ft. "," ft ")
	strTmp = Replace(strTmp," Feat "," ft ")
	strTmp = Replace(strTmp," Feat. "," ft ")
	' Beatforge and friends - put your SIGs in the ID3 tag plz
	strTmp = Replace(strTmp," Bf.mp3",".mp3")
	strTmp = Replace(strTmp," Bftop.mp3",".mp3")
	strTmp = Replace(strTmp," Xtd Bftop.mp3",".mp3")
	strTmp = Replace(strTmp," Nbd.mp3",".mp3")
	' If there is any space at the beginning then cut it!
	While Left(strTmp,1) = " "
		strTmp = Right(strTmp, Len(strTmp)-1)
	Wend
	ConvertName = strTmp
End Function


'*************************************************************************
' Recursively get directories
'*************************************************************************

Sub GetDir(dir)
Dim fh2,fh3,oFolder,oFolders,oFiles,item,Item2
Dim strOld, strNew, strTmp

Set oFolder=oFileSys.GetFolder(dir)
Set oFolders=oFolder.SubFolders
Set oFiles=oFolder.Files

' get all sub-folders in this folder
For each item in oFolders
	'go to each one
	GetDir(item)
Next
	item2=0
	For each item2 in oFiles
		strOld = Dir & "\" & item2.Name
		strNew = Dir & "\" & ConvertName(item2.Name)
		' Check what extension this file should have
		strTmp = strLayerCheck(strOld)
		' If this filename has a valid extension then check it, else add it.
		' And don't mess with unknown filetypes.
		If strTmp <> "unknown" Then
			If Mid(strNew, Len(strNew)-3, 1) = "." Then
				strNew = Left(strNew,Len(strNew)-4)
			End If
			strNew = strNew & strTmp
		End If
		' If the filename is mpeg something go to action
		If Mid(strNew, Len(strNew)-3, 3) = ".mp" Then
			' Comment out and in for test
			'set fh3=oFileSys.openTextFile("c:\" & "DirList.txt",8)
			'fh3.WriteLine("Old Name: " & strOld)
			'fh3.WriteLine("New Name: " & strNew)
			'fh3.close
			' Comment out and in for sharp run
			' Kill any previous identically named file
			If oFileSys.FileExists(strNew)
				oFileSys.DeleteFile strNew, True
			End If
			oFileSys.MoveFile strOld, strNew
		End If
	Next
End Sub

' Delete: WS_FTP.LOG, 

'************************************************************************
' The MAIN loop as we say in C
'************************************************************************

' Create the FileSystem Object
dim oFileSys, fh1
dim strDir
Const strTitleText = "VBS MP3 File Renamer"

strDir = BrowseForFolder("Choose a folder")

If IsNull(strDir) Then 
	MsgBox "Invalid Folder Selection", vbOKOnly + vbInformation, strTitleText
Else
	MsgBox "Press OK to process " & strDir, vbOKOnly + vbInformation, strTitleText
	' Create a filesystem object to be used throughout
	Set oFileSys = CreateObject("Scripting.FileSystemObject")
	' Comment out and in for test
	'Set fh1=oFileSys.createTextFile("c:\" & "DirList.txt")
	'fh1.WriteLine("Directory Listing starting at " & strDir)
	'fh1.close

	'Run the conversion
	GetDir strDir
	MsgBox "Filename fixing complete", vbOKOnly + vbInformation, strTitleText

End If

'************************************************************************
' End of program
'************************************************************************
