/* common.h
   Shared header file for the shftool package
   Requires Expat (commonly packaged as xmltok-dev)
   Copyright (C) 2003 Linus Walleij

This file is part of the shftool package.

Shftool is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

You should have received a copy of the GNU General Public License
along with Shftool; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. 

*/

#ifndef COMMON_INCLUDED
#define COMMON_INCLUDED 1

// Input and output types.

#define SHF_INPUT 0

#define SHF_OUTPUT 0
#define HEX_OUTPUT 1

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#else
typedef unsigned long long int u_int64_t;
typedef unsigned long int u_int32_t;
typedef unsigned char u_int8_t;
#endif
#if HAVE_STDBOOL_H
# include <stdbool.h>
#else
typedef enum {false = 0, true = 1} bool;
#endif
#include <stdio.h>
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_EXPAT_H
# include <expat.h>
#else
# include <xmlparse.h>
#endif
#define STR_MAXLEN      255
#define BUFFSIZE        8192

// Funny datatypes
typedef struct {
  u_int64_t number;
  char *name;
  u_int64_t address;
  u_int64_t word_length;
  u_int64_t length;
  u_int8_t *checksum;
  u_int64_t datap;
  u_int8_t *data;
} shf_block_t;


// Generic I/O functions
void OutString(char *fmt, ...);
void OutChar(char c, bool err);

// Utility functions
void destroy_block_t(shf_block_t *block);
char filterHex(char c);
u_int8_t hexToNybble(char c);
void outHexByte(u_int8_t c, bool err);
u_int64_t hexStrToULint(const char *str);
void dumpHexArray(u_int8_t *data, u_int64_t len, bool err);

// SHA-1 functions
void initialize_sha1();
void add_byte_to_sha1(u_int8_t c);
u_int8_t *retrieve_sha1(u_int64_t msglen);

// Generic output functions
void write_header(char *name, u_int64_t blocks);
void write_block(shf_block_t *block);
void write_footer();

// SHF processing
void SHF_write_header(char *name, u_int64_t blocks);
void SHF_write_block(shf_block_t *block);
void SHF_write_footer();
void SHF_process_file(FILE *infile);
void SHF_print_help();

// HEX processing
void HEX_write_header(char *name, u_int64_t blocks);
void HEX_write_block(shf_block_t *block);
void HEX_write_footer();
void HEX_print_help();

#endif
