/* hexdump.c
   Module for dumping blocks to text.
   Copyright (C) 2003 Linus Walleij

   This file is part of the shftool package.

   Shftool is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   You should have received a copy of the GNU General Public License
   along with Shftool; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. 

*/

#include "common.h"

// Read this from environment $COLUMNS
#define COLUMNS 80

void HEX_write_header(char *name, u_int64_t blocks)
{
  OutString("Dump:\n");
  OutString("  Name: %s\n", name);
  OutString("  Number of blocks: %llx\n", blocks);
}

void HEX_write_block(shf_block_t *block)
{
  u_int64_t i;
  int usedCols = 0;

  OutString("Block:\n");
  OutString("  Block number: %llx\n", block->number);
  OutString("  Block name: %s\n", block->name);
  OutString("  Address: %016llx\n", block->address);
  OutString("  Word size (in bytes): %llx\n", block->word_length);
  OutString("  Length (in words): %llx\n", block->length);
  OutString("  SHA-1 checksum: ");
  dumpHexArray(block->checksum, 20, false);
  OutString("\n");
  OutString("Data:\n");
  for (i = 0; i < (block->length * block->word_length); i += block->word_length) {
    if (usedCols + (block->word_length*2) + 1 > COLUMNS) {
      OutString("\n");
      OutString(" ");
      usedCols = block->word_length * 2 + 2;
    } else {
      OutString(" ");
      usedCols += block->word_length * 2 + 1;
    }

    // Dump it to screen
    dumpHexArray(block->data+i, block->word_length, false);
  }
  OutString("\n");
}

void HEX_write_footer()
{
  OutString("Dump ended.\n");
}

void HEX_print_help() {
  printf("         -o=hex           output hex dump\n");
}
