/* util.c
   Utility file for SHFtools.
   Copyright (C) 2003 Linus Walleij


   This file is part of the shftool package.

   Shftool is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   You should have received a copy of the GNU General Public License
   along with Shftool; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. 

*/

#include "common.h"

void destroy_block_t(shf_block_t *block) {
  if (block == NULL)
    return;
  if (block->name != NULL) {
    free(block->name);
  }
  if (block->checksum != NULL) {
    free(block->checksum);
  }
  if (block->data != NULL) {
    free(block->data);
  }
  free(block);
}

char filterHex(char c) {
  if (c >= '0' && c <= '9') {
    return c;
  }
  if (c >= 'a' && c <= 'f') {
    return c;
  }
  if (c >= 'A' && c <= 'F') {
    return c;
  }
  return '\0';
}

u_int8_t hexToNybble(char c) {
  if (c >= '0' && c <= '9') {
    return c - '0';
  }
  if (c >= 'a' && c <= 'f') {
    return c - 'a' + 10;
  }
  if (c >= 'A' && c <= 'F') {
    return c - 'A' + 10;
  }
  return '\0';
}

void outHexByte(u_int8_t c, bool err) {
  char outchars[] = "0123456789abcdef";

  OutChar(outchars[(c>>4) & 0xf], err);
  OutChar(outchars[c & 0xf], err);
}

u_int64_t hexStrToULint(const char *str) {
  int i, j;
  u_int64_t ret;
  
  // Convert this to an unsigned long integer
  j = 0;
  ret = 0;
  for (i=strlen(str)-1; i>=0; i--) {
    // Remove illegal characters
    if (filterHex(str[i]) != '\0') {
      u_int8_t b = hexToNybble(str[i]);
      // Caused by bug in GCC compiler (I guess?)
      // Left shifting a char is not possible for more than 32
      // bits. Damned...
      if (j < 32) {
	ret = ret | b << j;
      } else {
	u_int32_t t = b << (j - 32);
	ret = ret | (u_int64_t) t << 32;
      }
      j+=4;
    }
  }
  return ret;
}

void dumpHexArray(u_int8_t *data, u_int64_t len, bool err) {
  u_int64_t i;

  for (i = 0; i < len; i++) {
    outHexByte(data[i], err);
  }
}
